/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.editor;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class Internationalized$
implements LazyLogging {
    public static final Internationalized$ MODULE$;
    private final Locale currentLocale;
    private final ResourceBundle messages;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new Internationalized$();
    }

    private Logger logger$lzycompute() {
        Internationalized$ internationalized$ = this;
        synchronized (internationalized$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Locale currentLocale() {
        return this.currentLocale;
    }

    private ResourceBundle messages() {
        return this.messages;
    }

    public String getMessage(String key) {
        try {
            String rawValue = this.messages().getString(key);
            return new String(rawValue.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (MissingResourceException missingResourceException) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringOps(Predef$.MODULE$.augmentString("Missing translation for key: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new StringOps(Predef$.MODULE$.augmentString("$%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key}));
        }
    }

    public String getMessageColon(String key) {
        return new StringBuilder().append((Object)this.getMessage(key)).append((Object)":").toString();
    }

    public String needsTranslation(String key) {
        BoxedUnit boxedUnit;
        if (this.messages().containsKey(key)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Key \"%s\" marked as 'needsTranslation' ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key}))).append((Object)"in Scala source, but actually already exists.").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringOps(Predef$.MODULE$.augmentString("Accessed key \"%s\" needs translation.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return key;
    }

    public String needsTranslationColon(String key) {
        return new StringBuilder().append((Object)this.needsTranslation(key)).append((Object)":").toString();
    }

    public void obsoleteMessage(String key) {
        BoxedUnit boxedUnit;
        if (this.messages().containsKey(key)) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringOps(Predef$.MODULE$.augmentString("Key \"%s\" may be no longer needed. Remove from translation\n          message files, then remove obsoleteMessage(\"%s\") call.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key, key})));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(new StringOps(Predef$.MODULE$.augmentString("Call to obsoleteMessage(\"%s\") should be removed.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{key})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Internationalized$() {
        BoxedUnit boxedUnit;
        MODULE$ = this;
        LazyLogging$class.$init$(this);
        this.currentLocale = Locale.getDefault();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Current locale: ").append((Object)this.currentLocale().toString()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.messages = ResourceBundle.getBundle("editorMessages", this.currentLocale());
    }
}

